

<?php $__env->startSection('title', 'Editar Película'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Editar Película</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <form action="<?php echo e(route('peliculas.update', $pelicula)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="form-group">
                <label>Título</label>
                <input type="text" name="titulo" class="form-control" value="<?php echo e($pelicula->titulo); ?>" required>
            </div>
            <div class="form-group">
                <label>Duración (minutos)</label>
                <input type="number" name="duracion" class="form-control" value="<?php echo e($pelicula->duracion); ?>" required>
            </div>
            <div class="form-group">
                <label>Formato</label>
                <input type="text" name="formato" class="form-control" value="<?php echo e($pelicula->formato); ?>" required>
            </div>
            <div class="form-group">
                <label>Categoría</label>
                <select name="categoria_id" class="form-control" required>
                    <?php $__currentLoopData = $categorias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoria): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($categoria->id); ?>" <?php echo e($categoria->id == $pelicula->categoria_id ? 'selected' : ''); ?>>
                            <?php echo e($categoria->nombre); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="form-group">
                <label>Estado</label>
                <select name="estado" class="form-control" required>
                    <option value="disponible" <?php echo e($pelicula->estado == 'disponible' ? 'selected' : ''); ?>>Disponible</option>
                    <option value="alquilada" <?php echo e($pelicula->estado == 'alquilada' ? 'selected' : ''); ?>>Alquilada</option>
                </select>
            </div>
            <button type="submit" class="btn btn-success">Actualizar</button>
            <a href="<?php echo e(route('peliculas.index')); ?>" class="btn btn-secondary">Cancelar</a>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/edit.blade.php ENDPATH**/ ?>