

<?php $__env->startSection('title', 'Editar Alquiler'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Editar Alquiler</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form action="<?php echo e(route('alquileres.update', $alquiler->id ?? '')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pelicula_id">Película</label>
                            <select name="pelicula_id" id="pelicula_id" class="form-control select2" required>
                                <option value="">Seleccione una película</option>
                                <?php $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pelicula->id); ?>" 
                                        <?php echo e(old('pelicula_id', $alquiler->pelicula_id ?? '') == $pelicula->id ? 'selected' : ''); ?>>
                                        <?php echo e($pelicula->titulo); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cliente">Cliente</label>
                            <input type="text" name="cliente" id="cliente" class="form-control" required
                                value="<?php echo e(old('cliente', $alquiler->cliente ?? '')); ?>">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_entrada">Hora de Entrada</label>
                            <input type="time" name="hora_entrada" class="form-control" 
                                value="<?php echo e(old('hora_entrada', $alquiler->hora_entrada ?? '')); ?>">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_salida">Hora de Salida</label>
                            <input type="time" name="hora_salida" class="form-control" 
                                value="<?php echo e(old('hora_salida', $alquiler->hora_salida ?? '')); ?>">
                        </div>
                    </div>
                </div>
                <div class="mb-3">
    <label for="precio" class="form-label">Precio del alquiler</label>
    <input type="number" step="0.01" class="form-control" id="precio" name="precio" required>
</div>


                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <a href="<?php echo e(route('alquileres.index')); ?>" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <!-- Agregar Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            $('#pelicula_id').select2({
                placeholder: "Seleccione una película",
                allowClear: true
            });

            <?php if(session('success')): ?>
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: '<?php echo e(session('success')); ?>'
                });
            <?php endif; ?>

            <?php if($errors->any()): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: `<?php echo implode('<br>', $errors->all()); ?>`
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/edit.blade.php ENDPATH**/ ?>