<?php $__env->startSection('title', 'Editar Perfil'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Editar Perfil</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5 d-flex justify-content-center">
    <div class="card shadow-lg p-4 rounded" style="width: 50rem; background: #f8f9fa;">
        <div class="row">
            <div class="col-md-4 border-right d-flex flex-column align-items-center text-center p-3">
                <img class="rounded-circle mt-3" src="<?php echo e(asset('imagenes/mufasa.jpeg')); ?>" width="100">
                <h5 class="font-weight-bold mt-3"><?php echo e(auth()->user()->name); ?></h5>
                <span class="text-muted"><?php echo e(auth()->user()->email); ?></span>
            </div>
            <div class="col-md-8">
                <div class="p-3">
                    <h4 class="text-center text-primary">Editar Perfil</h4>
                    <form action="<?php echo e(route('profile.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <label class="form-label">Nombre</label>
                                <input type="text" class="form-control" name="name" value="<?php echo e(old('name', auth()->user()->name)); ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Correo Electrónico</label>
                                <input type="email" class="form-control" name="email" value="<?php echo e(old('email', auth()->user()->email)); ?>" required>
                            </div>
                        </div>
                        <hr>
                        <h5 class="text-center text-secondary mt-3">Actualizar Contraseña</h5>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <label class="form-label">Contraseña Actual</label>
                                <input type="password" class="form-control" name="current_password" placeholder="Ingrese su contraseña actual" required>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <label class="form-label">Nueva Contraseña</label>
                                <input type="password" class="form-control" name="password" placeholder="Ingrese nueva contraseña" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Confirmar Nueva Contraseña</label>
                                <input type="password" class="form-control" name="password_confirmation" placeholder="Confirme nueva contraseña" required>
                            </div>
                        </div>
                        <div class="mt-4 text-center">
                            <button class="btn btn-success px-4">Guardar Cambios</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/profile/edit.blade.php ENDPATH**/ ?>