

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2>Lista de Cobros</h2>
    <table class="table table-bordered text-center">
        <thead class="bg-dark text-white">
            <tr>
                <th>ID</th>
                <th>Alquiler ID</th>
                <th>Precio de la Película</th>
                <th>Monto Pagado</th>
                <th>Vuelto</th>
                <th>Fecha</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $cobros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cobro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($cobro->id); ?></td>
                    <td><?php echo e($cobro->alquiler_id); ?></td>
                    <td>S/<?php echo e(number_format($cobro->alquiler->precio ?? 0, 2)); ?></td>
                    <td>S/<?php echo e(number_format($cobro->monto, 2)); ?></td>
                    <td>S/<?php echo e(number_format($cobro->monto - ($cobro->alquiler->precio ?? 0), 2)); ?></td>
                    <td><?php echo e($cobro->fecha_cobro); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="d-flex justify-content-center">
        <?php echo e($cobros->links('pagination::bootstrap-4')); ?>

    </div>

    <!-- Sección del gráfico -->
    <h3 class="mt-4 text-center">Total Cobrado por Película</h3>
    <div class="d-flex justify-content-center">
    <div style="width: 300%; max-width: 2000px;">
        <canvas id="graficoCobros"></canvas>
    </div>
</div>
</div>

<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var ctx = document.getElementById("graficoCobros").getContext("2d");

        var data = {
            labels: <?php echo json_encode($totalesPorPelicula->keys()); ?>, // Nombres de películas
            datasets: [{
                label: "Total Recaudado (S/.)",
                data: <?php echo json_encode($totalesPorPelicula->values()); ?>, // Total de cobros
                backgroundColor: [
                    'rgba(255, 99, 132, 0.5)',
                    'rgba(54, 162, 235, 0.5)',
                    'rgba(255, 206, 86, 0.5)',
                    'rgba(75, 192, 192, 0.5)',
                    'rgba(153, 102, 255, 0.5)',
                    'rgba(255, 159, 64, 0.5)'
                ],
                borderColor: [
                    'rgba(255, 99, 132, 1)',
                    'rgba(54, 162, 235, 1)',
                    'rgba(255, 206, 86, 1)',
                    'rgba(75, 192, 192, 1)',
                    'rgba(153, 102, 255, 1)',
                    'rgba(255, 159, 64, 1)'
                ],
                borderWidth: 1
            }]
        };

        var myChart = new Chart(ctx, {
            type: 'doughnut',
            data: data,
            options: {
                responsive: true,
                maintainAspectRatio: false, // Permite ajustar tamaño
                cutout: '60%' // Hace que el gráfico sea más delgado
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/cobros/index.blade.php ENDPATH**/ ?>