<!DOCTYPE html>
<html>
<head>
    <title>Listado de Películas</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
    </style>
</head>
<body>
    <h1>Listado de Películas</h1>
    <table>
        <thead>
            <tr>
                <th>Título</th>
                <th>Duración</th>
                <th>Formato</th>
                <th>Categoría</th>
                <th>Estado</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($pelicula->titulo); ?></td>
                    <td><?php echo e($pelicula->duracion); ?> min</td>
                    <td><?php echo e($pelicula->formato); ?></td>
                    <td><?php echo e($pelicula->categoria->nombre); ?></td>
                    <td><?php echo e($pelicula->estado); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/pdf.blade.php ENDPATH**/ ?>