<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ticket Alquiler</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: "Courier New", monospace; /* Fuente tipo ticket */
            font-size: 16px;
            text-align: left;
            width: 80mm;
            margin: 0;
            background: white;
            padding: 5px;
        }

        .ticket {
            width: 100%;
            padding: 0;
        }

        .titulo {
    font-size: 20px; /* Título más grande */
    font-weight: bold;
    text-align: left; /* Alinear a la izquierda */
    margin-bottom: 5px;
    padding-left: 40px; /* Desplaza el texto a la derecha */
}

        .linea {
            display: block;
            font-size: 14px;
            text-align: left;
            margin: 2px 0;
        }

        .info {
            font-size: 14px;
            margin: 0;
            text-align: left;
            padding-left: 0; /* Sin sangría */
        }

        .resaltado {
            font-weight: bold;
        }

        .qr {
            text-align: left; /* Pegado a la izquierda */
            margin-top: 5px;
        }

        .agradecimiento {
            text-align: left; /* Pegado a la izquierda */
            font-size: 14px;
            margin-top: 5px;
            font-style: italic;
        }

        img {
            display: block;
            margin-left: 0; /* Pegado al borde izquierdo */
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="titulo">CINE WINDER </div>
        <span class="linea">-------------------------</span>
        
        <p class="info"><span class="resaltado">N° Ticket:</span> <?php echo e($alquiler->id); ?></p>
        <p class="info"><span class="resaltado">Fecha:</span> <?php echo e(now()->format('d/m/Y')); ?></p>
        <p class="info"><span class="resaltado">Cliente:</span> <?php echo e($alquiler->cliente); ?></p>
        <p class="info"><span class="resaltado">Película:</span> <?php echo e($alquiler->pelicula->titulo ?? 'Sin título'); ?></p>
        <p class="info"><span class="resaltado">Sala:</span> <?php echo e($alquiler->sala->nombre ?? 'Sin sala'); ?></p>
        <p class="info"><span class="resaltado">Entrada:</span> <?php echo e($alquiler->hora_entrada); ?></p>
        <p class="info"><span class="resaltado">Salida:</span> <?php echo e($alquiler->hora_salida); ?></p>
        <p class="info"><span class="resaltado">Duración:</span> <?php echo e($alquiler->pelicula->duracion ?? 'N/A'); ?></p>
        <p class="info"><span class="resaltado">Asientos:</span> <?php echo e($alquiler->asientos ?? 'Libre'); ?></p>
        <p class="info"><span class="resaltado">Método de Pago:</span> <?php echo e($alquiler->metodo_pago ?? 'Efectivo'); ?></p>
        <p class="info">
    <span class="resaltado">Código de Reserva:</span> 
    CV-<?php echo e(strtoupper(substr($alquiler->cliente, 0, 1))); ?><?php echo e(strtoupper(substr(strrchr($alquiler->cliente, ' '), 1, 1))); ?>-<?php echo e($alquiler->id); ?>

</p>
        <p class="info"><span class="resaltado">Precio:</span> S/ <?php echo e(number_format($alquiler->precio, 2)); ?></p>
        <p class="info"><span class="resaltado">Atendido por:</span> <?php echo e($alquiler->empleado ?? 'Elvis'); ?></p>

        
        <span class="linea">-------------------------</span>

        <!-- Código QR alineado a la izquierda -->
        <div class="qr">
            <img src="https://chart.googleapis.com/chart?chs=100x100&cht=qr&chl=TICKET-<?php echo e($alquiler->id); ?>" alt="QR Ticket">
        </div>

        <p class="agradecimiento">¡Gracias por su compra! </p>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/alquileres/ticket.blade.php ENDPATH**/ ?>