

<?php $__env->startSection('title', 'Lista de Películas'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Películas</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <a href="<?php echo e(route('peliculas.create')); ?>" class="btn btn-primary">Agregar Película</a>
    </div>
    <div class="card-body">
        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <table class="table table-bordered">
            <thead class="bg-primary text-white">
                <tr>
                    <th>ID</th>
                    <th>Título</th>
                    <th>Duración</th>
                    <th>Formato</th>
                    <th>Categoría</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $peliculas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pelicula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($pelicula->id); ?></td>
                        <td><?php echo e($pelicula->titulo); ?></td>
                        <td><?php echo e($pelicula->duracion); ?> min</td>
                        <td><?php echo e($pelicula->formato); ?></td>
                        <td><?php echo e($pelicula->categoria->nombre); ?></td>
                        <td>
                            <span class="badge <?php echo e($pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger'); ?>">
                                <?php echo e(ucfirst($pelicula->estado)); ?>

                            </span>
                        </td>
                        <td>
                            <a href="<?php echo e(route('peliculas.show', $pelicula)); ?>" class="btn btn-info btn-sm">Ver</a>
                            <a href="<?php echo e(route('peliculas.edit', $pelicula)); ?>" class="btn btn-warning btn-sm">Editar</a>
                            <form action="<?php echo e(route('peliculas.destroy', $pelicula)); ?>" method="POST" class="d-inline delete-form">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <!-- Paginación -->
        <div class="d-flex justify-content-center">
            <?php echo e($peliculas->links('pagination::bootstrap-4')); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            if (confirm('¿Estás seguro de eliminar esta película?')) {
                this.submit();
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\cinema-laravel11\resources\views/peliculas/index.blade.php ENDPATH**/ ?>