<?php
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\PeliculaController;
use App\Http\Controllers\CategoriaController;
use App\Http\Controllers\SalaController;
use App\Http\Controllers\AlquilerController;
use App\Http\Controllers\ClienteController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TicketController;
use App\Models\Alquiler;

use App\Http\Controllers\CobroController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

// Ruta de búsqueda de películas fuera del middleware de autenticación
Route::get('/peliculas/search', [PeliculaController::class, 'search'])->name('peliculas.search');
Route::get('/peliculas/exportar-pdf', [PeliculaController::class, 'exportToPDF'])->name('peliculas.export-pdf');

Route::post('/alquileres/cobrar/{id}', [AlquilerController::class, 'cobrar'])->name('alquileres.cobrar');

Route::post('/cobros/{id}', [CobroController::class, 'procesarCobro'])->name('cobros.procesar');





Route::get('/cobros', [CobroController::class, 'index'])->name('cobros.index');
Route::post('/cobros', [CobroController::class, 'store'])->name('cobros.store');


// 📌 ticket
Route::get('/alquileres/{id}/ticket', [AlquilerController::class, 'generarTicket'])->name('ticket.pdf');



Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // 📌 Rutas protegidas por autenticación
    Route::resource('peliculas', PeliculaController::class);
    Route::resource('categorias', CategoriaController::class);
    Route::resource('salas', SalaController::class);
    Route::resource('alquileres', AlquilerController::class);
    Route::resource('clientes', ClienteController::class);
});



// 📌 Mantén esta línea al final para manejar la autenticación
require __DIR__.'/auth.php';
