@extends('adminlte::page')

@section('title', 'Lista de Salas de Cine')

@section('content_header')
    <h1>Salas de Cine</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header">
        <a href="{{ route('salas.create') }}" class="btn btn-primary">Agregar Sala</a>
    </div>
    <div class="card-body">
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        <table class="table table-bordered">
            <thead class="bg-primary text-white">
                <tr>
                    <th>ID</th>
                    <th>Nombre</th>
                    <th>Capacidad</th>
                    <th>Tipo</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($salas as $sala)
                    <tr>
                        <td>{{ $sala->id }}</td>
                        <td>{{ $sala->nombre }}</td>
                        <td>
                            <i class="fas fa-users"></i> {{ $sala->capacidad }}
                        </td>
                        <td>
                            @if($sala->tipo == 'VIP')
                                <span class="badge bg-danger">
                                    <i class="fas fa-crown"></i> VIP
                                </span>
                            @else
                                <span class="badge bg-secondary">
                                    <i class="fas fa-theater-masks"></i> Normal
                                </span>
                            @endif
                        </td>
                        <td>
                            <a href="{{ route('salas.edit', $sala) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit"></i> Editar
                            </a>
                            <form action="{{ route('salas.destroy', $sala) }}" method="POST" class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">
                                    <i class="fas fa-trash"></i> Eliminar
                                </button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <div class="d-flex justify-content-center mt-3">
    {!! $salas->onEachSide(1)->links('vendor.pagination.bootstrap-5') !!}
</div>

    </div>
</div>
@stop

@section('js')
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();

            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Sí, eliminar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    });
</script>
@stop
