@extends('adminlte::page')

@section('title', 'Editar Sala')

@section('content_header')
    <h1>Editar Sala</h1>
@endsection

@section('content')
    <form action="{{ route('salas.update', $sala) }}" method="POST">
        @csrf
        @method('PUT')
        <div class="mb-3">
            <label for="nombre" class="form-label">Nombre de la Sala</label>
            <input type="text" name="nombre" class="form-control" value="{{ $sala->nombre }}" required>
        </div>
        <div class="mb-3">
            <label for="capacidad" class="form-label">Capacidad</label>
            <input type="number" name="capacidad" class="form-control" min="1" value="{{ $sala->capacidad }}" required>
        </div>
        <button type="submit" class="btn btn-primary">Actualizar</button>
        <a href="{{ route('salas.index') }}" class="btn btn-secondary">Cancelar</a>
    </form>
@endsection
