@extends('adminlte::page')

@section('title', 'Lista de Películas')

@section('content_header')
    <h1>Películas</h1>
@stop

@section('content')
<div class="card">
    <div class="card-header">
        <a href="{{ route('peliculas.create') }}" class="btn btn-primary">Agregar Película</a>
    </div>
    <div class="card-body">
        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        <table class="table table-bordered">
            <thead class="bg-primary text-white">
                <tr>
                    <th>ID</th>
                    <th>Título</th>
                    <th>Duración</th>
                    <th>Formato</th>
                    <th>Categoría</th>
                    <th>Estado</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($peliculas as $pelicula)
                    <tr>
                        <td>{{ $pelicula->id }}</td>
                        <td>{{ $pelicula->titulo }}</td>
                        <td>{{ $pelicula->duracion }} min</td>
                        <td>{{ $pelicula->formato }}</td>
                        <td>{{ $pelicula->categoria->nombre }}</td>
                        <td>
                            <span class="badge {{ $pelicula->estado == 'disponible' ? 'bg-success' : 'bg-danger' }}">
                                {{ ucfirst($pelicula->estado) }}
                            </span>
                        </td>
                        <td>
                            <a href="{{ route('peliculas.show', $pelicula) }}" class="btn btn-info btn-sm">Ver</a>
                            <a href="{{ route('peliculas.edit', $pelicula) }}" class="btn btn-warning btn-sm">Editar</a>
                            <form action="{{ route('peliculas.destroy', $pelicula) }}" method="POST" class="d-inline delete-form">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-sm">Eliminar</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        <!-- Paginación -->
        <div class="d-flex justify-content-center">
            {{ $peliculas->links('pagination::bootstrap-4') }}
        </div>
    </div>
</div>
@stop

@section('js')
<script>
    document.querySelectorAll('.delete-form').forEach(form => {
        form.addEventListener('submit', function(event) {
            event.preventDefault();
            if (confirm('¿Estás seguro de eliminar esta película?')) {
                this.submit();
            }
        });
    });
</script>
@stop
