@extends('adminlte::page')

@section('title', 'Editar Película')

@section('content_header')
    <h1>Editar Película</h1>
@stop

@section('content')
<div class="card">
    <div class="card-body">
        <form action="{{ route('peliculas.update', $pelicula) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="form-group">
                <label>Título</label>
                <input type="text" name="titulo" class="form-control" value="{{ $pelicula->titulo }}" required>
            </div>
            <div class="form-group">
                <label>Duración (minutos)</label>
                <input type="number" name="duracion" class="form-control" value="{{ $pelicula->duracion }}" required>
            </div>
            <div class="form-group">
                <label>Formato</label>
                <input type="text" name="formato" class="form-control" value="{{ $pelicula->formato }}" required>
            </div>
            <div class="form-group">
                <label>Categoría</label>
                <select name="categoria_id" class="form-control" required>
                    @foreach ($categorias as $categoria)
                        <option value="{{ $categoria->id }}" {{ $categoria->id == $pelicula->categoria_id ? 'selected' : '' }}>
                            {{ $categoria->nombre }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group">
                <label>Estado</label>
                <select name="estado" class="form-control" required>
                    <option value="disponible" {{ $pelicula->estado == 'disponible' ? 'selected' : '' }}>Disponible</option>
                    <option value="alquilada" {{ $pelicula->estado == 'alquilada' ? 'selected' : '' }}>Alquilada</option>
                </select>
            </div>
            <button type="submit" class="btn btn-success">Actualizar</button>
            <a href="{{ route('peliculas.index') }}" class="btn btn-secondary">Cancelar</a>
        </form>
    </div>
</div>
@stop
