@extends('adminlte::page')

@section('title', 'Detalles del Alquiler')

@section('content_header')
    <h1>Detalles del Alquiler</h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-body">
            <table class="table table-bordered">
                <tr>
                    <th>Película</th>
                    <td>{{ $alquiler->pelicula?->titulo ?? 'Película no encontrada' }}</td>
                </tr>
                <tr>
                    <th>Cliente</th>
                    <td>{{ $alquiler->cliente }}</td>
                </tr>
                <tr>
                    <th>Sala</th>
                    <td>{{ $alquiler->sala?->nombre ?? 'Sala no encontrada' }}</td>
                </tr>
                <tr>
        <th>Hora de Inicio</th>
        <td>{{ $alquiler->hora_inicio }}</td>
    </tr>
    <tr>
        <th>Hora de Fin</th>
        <td>{{ $alquiler->hora_fin }}</td>
    </tr>
    <tr>
                    <th>Fecha Fin</th>
                    <td>{{ $alquiler->hora_fin }}</td>
                </tr>
                <tr>
                    <th>Fecha de Devolución</th>
                    <td>{{ $alquiler->fecha_devolucion }}</td>
                </tr>
            </table>
            <a href="{{ route('alquileres.index') }}" class="btn btn-secondary mt-3">Volver</a>
        </div>
    </div>
@endsection
