@extends('adminlte::page')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title">Lista de Alquileres</h3>
                    <div class="card-tools">
                        <a href="{{ route('alquileres.create') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-plus"></i> Nuevo Alquiler
                        </a>
                    </div>
                </div>
                
                <div class="card-body">
                    <table class="table table-bordered table-striped text-center">
                        <thead class="bg-secondary text-white">
                            <tr>
                                <th>ID</th>
                                <th>Película</th>
                                <th>Cliente</th>
                                <th>Sala</th>
                                <th>Hora de Entrada</th>
                                <th>Hora de Salida</th>
                                <th>Precio</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($alquileres as $alquiler)
                                <tr>
                                    <td>{{ $alquiler->id }}</td>
                                    <td>{{ $alquiler->pelicula->titulo ?? 'Sin título' }}</td>
                                    <td>{{ $alquiler->cliente }}</td>
                                    <td>
                                        @if ($alquiler->sala)
                                            <span class="badge {{ $alquiler->sala->tipo === 'VIP' ? 'badge-danger' : 'badge-primary' }}">
                                                {!! $alquiler->sala->tipo === 'VIP' ? '<i class="fas fa-crown"></i> VIP' : '<i class="fas fa-chair"></i> Normal' !!}
                                            </span>
                                            <strong>{{ $alquiler->sala->nombre }}</strong>
                                        @else
                                            <span class="text-muted">Sin sala</span>
                                        @endif
                                    </td>
                                    <td>{{ $alquiler->hora_entrada }}</td>
                                    <td>{{ $alquiler->hora_salida }}</td>
                                    <td><strong>S/{{ number_format($alquiler->precio, 2) }}</strong></td>
                                    <td>
                                        @if ($alquiler->estado === 'pagado')
                                            <span class="badge badge-success"><i class="fas fa-check-circle"></i> Pagado</span>
                                        @else
                                            <span class="badge badge-warning"><i class="fas fa-exclamation-circle"></i> Pendiente</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{ route('alquileres.show', $alquiler) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('alquileres.edit', $alquiler) }}" class="btn btn-warning btn-sm">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <button class="btn btn-danger btn-sm" onclick="eliminarAlquiler({{ $alquiler->id }})">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                        <button class="btn btn-success btn-sm" onclick="abrirModalCobro({{ $alquiler->id }}, {{ $alquiler->precio }})">
                                            <i class="fas fa-cash-register"></i> Cobrar
                                        </button>
                                        <a href="{{ route('ticket.pdf', $alquiler->id) }}" class="btn btn-secondary btn-sm" target="_blank">
                                            <i class="fas fa-receipt"></i> Ticket
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="d-flex justify-content-center">
                    {{ $alquileres->links('pagination::bootstrap-4') }}
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Cobro -->
<div id="modalCobro" class="modal fade" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Cobrar Alquiler</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <input type="hidden" id="alquiler_id">
                <p>Precio: <strong id="precio"></strong></p>
                <label>Monto Pagado:</label>
                <input type="number" id="monto_pagado" name="monto_pagado" class="form-control">

                <p>Vuelto: <strong id="vuelto"></strong></p>
            </div>
            <div class="modal-footer">
                <button class="btn btn-primary" onclick="procesarCobro()">Cobrar</button>
            </div>
        </div>
    </div>
</div>

<script>
   function abrirModalCobro(id, precio) {
    document.getElementById('alquiler_id').value = id;
    document.getElementById('precio').textContent = precio;
    document.getElementById('monto_pagado').value = '';
    document.getElementById('vuelto').textContent = '0';
    new bootstrap.Modal(document.getElementById('modalCobro')).show();
}

    document.getElementById("monto_pagado").addEventListener("input", function () {
        let precio = parseFloat(document.getElementById("precio").innerText);
        let montoPagado = parseFloat(this.value);
        let vuelto = montoPagado - precio;
        document.getElementById("vuelto").innerText = vuelto >= 0 ? vuelto.toFixed(2) : "Monto insuficiente";
    });

    function procesarCobro() {
    let id = document.getElementById('alquiler_id').value;
    let montoPagado = parseFloat(document.getElementById('monto_pagado').value);

    if (isNaN(montoPagado)) {
        alert("Ingrese un monto válido.");
        return;
    }

    fetch(`/alquileres/cobrar/${id}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({ monto: montoPagado }) // 👈 Cambiado a "monto"
    })
    .then(response => response.json())
    .then(data => {
        alert(data.mensaje);
        if (data.mensaje.includes('éxito')) {
            location.reload();
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Hubo un error al procesar el cobro.');
    });
}


function eliminarAlquiler(id) {
    if (confirm("¿Estás seguro de eliminar este alquiler?")) {
        fetch(`/alquileres/${id}`, {
            method: "DELETE",
            headers: {
                "X-CSRF-TOKEN": document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert("Alquiler eliminado correctamente");

                // Eliminar la fila sin recargar la página
                document.getElementById(`fila-${id}`).remove();
            } else {
                alert("Error al eliminar el alquiler");
            }
        })
        .catch(error => console.error("Error:", error));
    }
}

</script>

@endsection
