@extends('adminlte::page')

@section('title', 'Editar Alquiler')

@section('content_header')
    <h1>Editar Alquiler</h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('alquileres.update', $alquiler->id ?? '') }}" method="POST">
                @csrf
                @method('PUT')

                <div class="form-group">
                    <label for="pelicula_id">Película</label>
                    <select name="pelicula_id" id="pelicula_id" class="form-control" required>
                        @foreach($peliculas as $pelicula)
                            <option value="{{ $pelicula->id }}" {{ $alquiler->pelicula_id == $pelicula->id ? 'selected' : '' }}>
                                {{ $pelicula->titulo }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="form-group">
                    <label for="cliente">Cliente</label>
                    <input type="text" name="cliente" class="form-control" value="{{ $alquiler->cliente ?? '' }}" required>
                </div>

                <div class="form-group">
                    <label for="fecha_inicio">Fecha de Inicio</label>
                    <input type="date" name="fecha_inicio" class="form-control" value="{{ $alquiler->fecha_inicio ?? '' }}" required>
                </div>

                <div class="form-group">
                    <label for="fecha_alquiler">Fecha de Alquiler</label>
                    <input type="date" name="fecha_alquiler" class="form-control" value="{{ $alquiler->fecha_alquiler ?? '' }}" required>
                </div>

                <div class="form-group">
                    <label for="fecha_devolucion">Fecha de Devolución</label>
                    <input type="date" name="fecha_devolucion" class="form-control" value="{{ $alquiler->fecha_devolucion ?? '' }}" required>
                </div>

                <button type="submit" class="btn btn-primary">Actualizar</button>
                <a href="{{ route('alquileres.index') }}" class="btn btn-secondary">Cancelar</a>
            </form>
        </div>
    </div>
@endsection

@section('js')
    <script>
        @if(session('success'))
            Swal.fire({
                icon: 'success',
                title: 'Éxito',
                text: '{{ session('success') }}'
            });
        @endif
    </script>
@endsection
