@extends('adminlte::page')

@section('title', 'Editar Alquiler')

@section('content_header')
    <h1>Editar Alquiler</h1>
@endsection

@section('content')
    <div class="card">
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('alquileres.update', $alquiler->id ?? '') }}" method="POST">
                @csrf
                @method('PUT')

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="pelicula_id">Película</label>
                            <select name="pelicula_id" id="pelicula_id" class="form-control select2" required>
                                <option value="">Seleccione una película</option>
                                @foreach($peliculas as $pelicula)
                                    <option value="{{ $pelicula->id }}" 
                                        {{ old('pelicula_id', $alquiler->pelicula_id ?? '') == $pelicula->id ? 'selected' : '' }}>
                                        {{ $pelicula->titulo }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="cliente">Cliente</label>
                            <input type="text" name="cliente" id="cliente" class="form-control" required
                                value="{{ old('cliente', $alquiler->cliente ?? '') }}">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_entrada">Hora de Entrada</label>
                            <input type="time" name="hora_entrada" class="form-control" 
                                value="{{ old('hora_entrada', $alquiler->hora_entrada ?? '') }}">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="hora_salida">Hora de Salida</label>
                            <input type="time" name="hora_salida" class="form-control" 
                                value="{{ old('hora_salida', $alquiler->hora_salida ?? '') }}">
                        </div>
                    </div>
                </div>
                <div class="mb-3">
    <label for="precio" class="form-label">Precio del alquiler</label>
    <input type="number" step="0.01" class="form-control" id="precio" name="precio" required>
</div>


                <div class="d-flex justify-content-between">
                    <button type="submit" class="btn btn-primary">Actualizar</button>
                    <a href="{{ route('alquileres.index') }}" class="btn btn-secondary">Cancelar</a>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('js')
    <!-- Agregar Select2 -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            $('#pelicula_id').select2({
                placeholder: "Seleccione una película",
                allowClear: true
            });

            @if(session('success'))
                Swal.fire({
                    icon: 'success',
                    title: 'Éxito',
                    text: '{{ session('success') }}'
                });
            @endif

            @if ($errors->any())
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    html: `{!! implode('<br>', $errors->all()) !!}`
                });
            @endif
        });
    </script>
@endsection
