@extends('adminlte::page')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12 col-md-8 offset-md-2 col-lg-6">
            <div class="card shadow-lg">
                <div class="card-header bg-primary text-white">
                    <h3 class="card-title">Registrar Nuevo Alquiler</h3>
                </div>
                <div class="card-body">
                    {{-- Validación de errores --}}
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form id="alquiler-form" action="{{ route('alquileres.store') }}" method="POST">
                        @csrf

                        <div class="form-group">
                            <label for="pelicula_search">Película</label>
                            <div class="input-group">
                                <input type="text" id="pelicula_search" class="form-control" placeholder="Escribe el nombre de la película" autocomplete="yes" required>
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" type="button" id="search-btn">
                                        <i class="fas fa-search"></i>
                                    </button>
                                </div>
                            </div>
                            <!-- Cuadro para mostrar los resultados -->
                            <div id="search-results" class="list-group" style="display: none;"></div>
                            <input type="hidden" name="pelicula_id" id="pelicula_id">
                        </div>

                        {{-- Selección de Sala --}}
                        <div class="form-group">
                            <label for="sala_id">Sala</label>
                            <select name="sala_id" id="sala_id" class="form-control select2" required>
                                <option value="" disabled selected>Seleccione una sala</option>
                                @foreach ($salas as $sala)
                                    <option value="{{ $sala->id }}" {{ old('sala_id') == $sala->id ? 'selected' : '' }}>
                                        {{ $sala->nombre }}
                                    </option>
                                @endforeach
                            </select>
                        </div>

                        {{-- Cliente --}}
                        <div class="form-group">
                            <label for="cliente">Cliente</label>
                            <input type="text" name="cliente" id="cliente" class="form-control" 
                                   placeholder="Ingrese el nombre del cliente" 
                                   value="{{ old('cliente') }}" required>
                        </div>

                        {{-- Hora de Entrada --}}
                        <div class="form-group">
                            <label for="hora_entrada">Hora de Entrada</label>
                            <input type="time" name="hora_entrada" id="hora_entrada" class="form-control" 
                                   value="{{ old('hora_entrada') }}" required>
                        </div>

                        {{-- Hora de Salida --}}
                        <div class="form-group">
                            <label for="hora_salida">Hora de Salida</label>
                            <input type="time" name="hora_salida" id="hora_salida" class="form-control" 
                                   value="{{ old('hora_salida') }}" required>
                        </div>
                        <div class="mb-3">
                        <div class="form-group">
    <label for="precio">Precio (S/)</label>
    <input type="number" name="precio" id="precio" class="form-control" step="0.01" min="0" required>
</div>


                        {{-- Botones --}}
                        <div class="d-flex justify-content-between mt-4">
                            <button type="submit" class="btn btn-success btn-lg" id="btn-submit">
                                <i class="fas fa-save"></i> Guardar
                            </button>
                            <a href="{{ route('alquileres.index') }}" class="btn btn-secondary btn-lg">
                                <i class="fas fa-times"></i> Cancelar
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

{{-- Agregar Select2 y SweetAlert --}}
@section('js')
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
      $(document).ready(function() {
    // Función para buscar películas
    $('#pelicula_search').on('keyup', function() {
        var searchTerm = $(this).val();
        $('#search-results').hide(); // Ocultar los resultados anteriores

        if (searchTerm.length > 2) { // Solo hace la búsqueda si tiene más de 2 caracteres
            $.ajax({
                url: '{{ route('peliculas.search') }}',
                method: 'GET',
                data: { term: searchTerm },
                success: function(response) {
                    $('#search-results').empty(); // Limpiar resultados anteriores

                    if(response.peliculas.length > 0) {
                        // Mostrar los resultados en el cuadro
                        response.peliculas.forEach(function(pelicula) {
                            $('#search-results').append('<a href="#" class="list-group-item list-group-item-action font-weight-bold" data-id="' + pelicula.id + '" data-title="' + pelicula.titulo + '">' + pelicula.titulo + '</a>');
                        });
                        $('#search-results').show(); // Mostrar los resultados
                    } else {
                        $('#search-results').hide(); // Ocultar si no hay resultados
                    }
                },
                error: function() {
                    console.error('Error al realizar la búsqueda de películas');
                }
            });
        } else {
            $('#search-results').hide(); // Ocultar si no hay texto de búsqueda
        }
    });

    // Seleccionar una película
    $('#search-results').on('click', 'a', function() {
        var id = $(this).data('id');
        var title = $(this).data('title');
        $('#pelicula_search').val(title); // Poner el título en el input
        $('#pelicula_id').val(id); // Asignar el ID al campo oculto
        $('#search-results').hide(); // Ocultar los resultados
    });

    // SweetAlert para mostrar mensaje de éxito
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Éxito',
            text: '{{ session('success') }}'
        });
    @endif

    // Confirmación antes de enviar el formulario
    $('#alquiler-form').submit(function(e) {
        e.preventDefault();
        
        // Obtener las horas de entrada y salida
        var horaEntrada = $('#hora_entrada').val();
        var horaSalida = $('#hora_salida').val();

        // Verificar si la hora de salida es antes que la de entrada
        if (horaSalida <= horaEntrada) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'La hora de salida no puede ser anterior a la hora de entrada.',
                confirmButtonText: 'Aceptar'
            });
        } else {
            Swal.fire({
                title: '¿Confirmar alquiler?',
                text: "Asegúrese de que los datos sean correctos.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, guardar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        }
    });
});

    </script>  
@endsection
