<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::table('alquileres', function (Blueprint $table) {
            $table->dropColumn('fecha_inicio');
            $table->dropColumn('fecha_fin');
            $table->time('hora_entrada')->after('cliente');
            $table->time('hora_salida')->after('hora_entrada');
        });
    }

    public function down()
    {
        Schema::table('alquileres', function (Blueprint $table) {
            $table->dropColumn('hora_entrada');
            $table->dropColumn('hora_salida');
            $table->date('fecha_inicio')->after('cliente');
            $table->date('fecha_fin')->after('fecha_inicio');
        });
    }
};

